class AdvancedUserRecipe1289709253(BasicNewsRecipe):
    title          = u'Digital Home'
    oldest_article = 7
    max_articles_per_feed = 100
    summary_length         = 100   
    use_embedded_content  = False
    no_stylesheets = True

    remove_javascript     = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        h2{font-family:Georgia,serif; font-weight:normal;font-size:small;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''
	                 

    remove_tags_before = dict(id='contentleft')
    remove_tags = [dict(name='div', attrs={'class':['postcomments','breadcrumb','postauthor','postmeta']}),
                   dict(name='div', attrs={'id':['sidebar','footer','searchbar']}),
                   dict(name='img')]


    feeds       = [(u'News', u'http://www.digitalhome.ca/feed/rss/')]


    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup
		